;;;====================================;;;
;;;  CONVERT MILADI TO SHAMSI AVR ASSEMBLY PROGRAM        ;;;
;;;                     WRITEN BY : S.M.Mousavi                                     ;;;
;;;====================================;;;
;;;;;;;;;;;;;;;;;                   ATMEGA16                     ;;;;;;;;;;;;;;;;;;;;;;

	.equ	SPH		=$3e
	.equ	SPL		=$3d
	.equ 	RAMEND                  =$45F

	.equ	day		=$100
	.equ	month		=$101
	.equ	year		=$102
;-------------------------------------------------------------------------------------------------------

	LDI  R30,LOW(RAMEND)
	OUT  SPL,R30
	LDI  R30,HIGH(RAMEND)
	OUT  SPH,R30
;...........................
main:
;...
;...
;...
;::::::::::::::::::::::::::::::::::::::::::::::::::	;load shamsi date (in BCD format) into day,month,year location
;--------------------	;for example Miladi  date is :  2008/01/25   -------------------------			
	ldi	r20,0x25		
	sts	day,r20
	ldi	r20,0x1
	sts	month,r20
	ldi	r20,0x08
	sts	year,r20
;--------------------------------------------------------------------------------------------
 	lds	r20,day		
 	lds	r21,month
 	lds	r22,year

	call		Convert_date     

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;converted date(in BCD format) available in  day,month,year location

;...
;...
;...
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; End Of Program  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;==================================================================
Convert_date:
		
		call	convert_hex
		call	leap_check
		cpi		r20,0x30
		breq	fdt1
		call	convert
fdt1:
		call	change_year
		call	hextobcd
exit:
		RET
;
;===========================
hextobcd:
		cpi		r20,0x30	;is it=12/30
		breq	he1			;yes go next
		mov		r16,r20
		call	HTOB
		mov		r20,r16

		mov		r16,r21
		call	HTOB
		mov		r21,r16
he1:
		mov		r16,r22
		cpi		r16,100
		brlo	he2
		ldi		r17,100
		sub		r16,r17
he2:
		call	HTOB
		mov		r22,r16

		ret
;==========================
HTOB:
		ldi		r17,0x0A
		ldi		r18,00
hb1:
		sub		r16,r17
		brcs	hb2
		inc		r18
		rjmp	hb1
hb2:
		add		r16,r17	
		swap	r18
		or		r16,r18
		ret		
;=========================
leap_check:
		mov		r16,r22
		andi	r16,0x03
		brne	le10
		cpi		r21,3
		brlo	leap_exit
		rjmp	le13
le10:
		cpi		r16,0x01
		brne	leap_exit
		cpi		r21,3
		brlo	le13
		breq	le11
		brsh	leap_exit
le11:
		cpi		r20,20
		breq	le12
		brsh	leap_exit
		rjmp	le13
le12:
		ldi		r20,0x2F
		ldi		r21,0x12
le13:
		inc		r20
leap_exit:
		ret
;====================
convert:
	mov		r16,r21
 	ldi		r17,9
 	add		r16,r17
 	cpi		r16,12
 	brlo	j1
	breq    j1
	ldi		r17,12
	sub		r16,r17

j1:
 	mov	r21,r16		;shamsi month adjusted 
	
j2:
		ldi	r30,low(Shams<<1)
		ldi r31,high(Shams<<1)

		mov		r16,r21
		dec		r16
		add		r30,r16

		mov		r16,r20
		lpm		r17,Z+
		add		r16,r17
		ldi		r17,31
		cpi		r21,7
		brlo	k3
		cpi		r21,12
		brlo	k2
		ldi		r17,30
k2:
		dec		r17
k3:
		cp		r16,r17
		brlo	k4
		breq	k4
		inc		r21
		cpi		r21,13
		brlo	k5
		ldi		r21,1
k5:
		sub		r16,r17
k4:
		mov		r20,r16
		ret
;===========================
change_year:
		mov		r18,r22
		ldi		r16,79
		add		r22,r16
		mov		r16,r22
		andi	r16,0x0F
		cpi		r16,0x0A
		brlo	cg1
		ldi		r17,6
		add		r22,r17
cg1:
		cpi		r21,10
		brlo	cg4
		breq	cg2
		brsh	cg3
cg2:
		ldi		r17,11
		andi	r18,0x01
		brne	cg22
		inc		r17
cg22:
		cp		r20,r17
		brlo	cg4
cg3:
		dec		r22
cg4:
		ret
;===================
convert_hex:
		mov		r16,r20
		call	BTOH
		mov		r20,r16

		cpi		r21,0x10
		brlo	ch1
		ldi		r16,6
		sub		r21,r16
ch1:
		mov		r16,r22
		call	BTOH
		mov		r22,r16

		ret
;=====================
BTOH:
	mov		r18,r16
	andi	r18,0xF0
	swap	r18
	ldi		r17,0x0A
	mul		r17,r18
	andi	r16,0x0F
	add		r16,r0
	ret	
;=====================================================
.org   0x800
Shams:
.db	    	11,10,10,9,9,9,8,9,9,10,11,9
